<?php
$title = "Editar importe";
ob_start(); ?>
<div class="card">
  <div class="h1">Editar importe</div>
  <form method="post" action="index.php?r=assist_save">
    <input type="hidden" name="id" value="<?= (int)$row['id'] ?>">
    <input type="hidden" name="period" value="<?= h($period) ?>">

    <div class="row">
      <div>
        <label>Deudor</label>
        <select name="debtor_id" required>
          <?php foreach ($debtors as $d): ?>
            <option value="<?= (int)$d['id'] ?>" <?= (int)$d['id']===(int)$row['debtor_id']?'selected':'' ?>>
              <?= h($d['id_number'] . ' - ' . $d['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Asistencia crediticia (código)</label>
        <select name="assist_code" required>
          <?php foreach ($assists as $a): ?>
            <option value="<?= h($a['code']) ?>" <?= $a['code']===$row['assist_code']?'selected':'' ?>>
              <?= h($a['code'] . ' - ' . $a['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>

    <div style="margin-top:12px">
      <label>Importe (en pesos)</label>
      <input name="amount_pesos" type="number" min="0" required value="<?= (int)$row['amount_pesos'] ?>">
    </div>

    <div style="display:flex; gap:10px; margin-top:14px">
      <button class="btn" type="submit">Guardar</button>
      <a class="btn secondary" href="index.php?r=assists&period=<?= h($period) ?>">Volver</a>
    </div>
  </form>
</div>

<?php
$content = ob_get_clean();
require __DIR__ . '/layout.php';
