<?php
$title = "Importes (Asistencias)";
ob_start(); ?>
<div class="card">
  <div class="h1">Importes (IMPORTES.TXT)</div>
  <form method="get" action="index.php">
    <input type="hidden" name="r" value="assists">
    <div class="row">
      <div>
        <label>Período (YYYYMM)</label>
        <input name="period" value="<?= h($period) ?>" placeholder="202512" required>
        <div class="small">Podés cargar meses futuros.</div>
      </div>
      <div style="display:flex; align-items:end; gap:10px">
        <button class="btn" type="submit">Ver período</button>
        <a class="btn secondary" href="index.php?r=assists&period=<?= h(date('Ym')) ?>">Mes actual</a>
      </div>
    </div>
  </form>
</div>

<div class="card">
  <div class="h1">Cargar / editar importe</div>
  <form method="post" action="index.php?r=assist_save">
    <input type="hidden" name="period" value="<?= h($period) ?>">
    <div class="row">
      <div>
        <label>Deudor</label>
        <select name="debtor_id" required>
          <option value="">Seleccionar...</option>
          <?php foreach ($debtors as $d): ?>
            <option value="<?= (int)$d['id'] ?>">
              <?= h($d['id_number'] . ' - ' . $d['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Asistencia crediticia (código)</label>
        <select name="assist_code" required>
          <?php foreach ($assists as $a): ?>
            <option value="<?= h($a['code']) ?>"><?= h($a['code'] . ' - ' . $a['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>
    <div style="margin-top:12px">
      <label>Importe (en pesos, sin decimales)</label>
      <input name="amount_pesos" type="number" min="0" required placeholder="Ej: 2658500">
      <div class="small">Al exportar se convierte a miles (ej: 2.658.500 =&gt; 2659).</div>
    </div>
    <div style="display:flex; gap:10px; margin-top:14px">
      <button class="btn" type="submit">Guardar</button>
    </div>
  </form>
</div>

<div class="card">
  <div class="h1">Importes cargados - <?= h($period) ?></div>
  <table class="table">
    <thead>
      <tr>
        <th>Deudor</th>
        <th>Asistencia</th>
        <th>Importe (pesos)</th>
        <th>Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?= h($r['id_number'].' - '.$r['name']) ?></td>
          <td><span class="badge"><?= h($r['assist_code']) ?></span> <?= h($r['assist_name']) ?></td>
          <td><?= number_format((int)$r['amount_pesos'], 0, ',', '.') ?></td>
          <td style="white-space:nowrap">
            <a class="btn secondary" href="index.php?r=assist_edit&id=<?= (int)$r['id'] ?>&period=<?= h($period) ?>">Editar</a>
            <a class="btn danger" data-confirm="¿Eliminar importe?" href="index.php?r=assist_delete&id=<?= (int)$r['id'] ?>&period=<?= h($period) ?>">Eliminar</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
  <?php if (count($rows)===0): ?><p class="small">Sin importes cargados.</p><?php endif; ?>
</div>

<?php
$content = ob_get_clean();
require __DIR__ . '/layout.php';
