
PRAGMA foreign_keys = ON;

CREATE TABLE IF NOT EXISTS settings (
  key TEXT PRIMARY KEY,
  value TEXT NOT NULL
);

CREATE TABLE IF NOT EXISTS debtors (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  id_type INTEGER NOT NULL DEFAULT 11,               -- 11 CUIT/CUIL/CDI; 98/99 exterior
  id_number TEXT NOT NULL,                           -- 11 chars max
  name TEXT NOT NULL,                                -- denominación (se exporta MAYUS/ sin tildes)
  situation_code TEXT NOT NULL DEFAULT '01',          -- 01,21,03,04,05
  art26_flag INTEGER NOT NULL DEFAULT 0,              -- campo 6 (0/1)
  recat_flag INTEGER NOT NULL DEFAULT 0,              -- campo 7 (0/1)
  days_overdue INTEGER,                               -- campo 8 (nullable)
  situation_without_reclass TEXT NOT NULL DEFAULT '00', -- campo 9
  active INTEGER NOT NULL DEFAULT 1,
  created_at TEXT NOT NULL DEFAULT (datetime('now')),
  updated_at TEXT NOT NULL DEFAULT (datetime('now')),
  UNIQUE(id_type, id_number)
);

CREATE TABLE IF NOT EXISTS assists (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  code TEXT NOT NULL,            -- 01,04,06,08,09,10,13,15,19,20,33,99
  name TEXT NOT NULL
);

CREATE TABLE IF NOT EXISTS debtor_assists (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  debtor_id INTEGER NOT NULL,
  period TEXT NOT NULL,          -- YYYYMM
  assist_code TEXT NOT NULL,
  amount_pesos INTEGER NOT NULL, -- en pesos (sin decimales)
  FOREIGN KEY(debtor_id) REFERENCES debtors(id) ON DELETE CASCADE,
  FOREIGN KEY(assist_code) REFERENCES assists(code) ON DELETE RESTRICT,
  UNIQUE(debtor_id, period, assist_code)
);

CREATE TABLE IF NOT EXISTS rates (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  period TEXT NOT NULL UNIQUE,   -- YYYYMM
  no_real_guarantee INTEGER NOT NULL DEFAULT 0, -- campo 1 (0/1)
  weighted_rate TEXT NOT NULL DEFAULT '000,00'  -- campo 2 formato EEE,DD
);

